% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{find_neededNeighbours}
\alias{find_neededNeighbours}
\title{This function querries if a suite of genotypes exist within the fitness landscape database.}
\usage{
find_neededNeighbours(tmp_possibleNeighbours, tmp_focal_numMuts,
  tmp_refTables, maxHamming = getOption("shape_max_numMutations"),
  tmp_tableSplit = getOption("shape_db_splitTables"),
  tmp_genomeLength = getOption("shape_genomeLength"),
  tmpDirection = getOption("shape_allow_backMutations"),
  tmpRange_numMuts = NULL, tmp_genCon)
}
\arguments{
\item{tmp_possibleNeighbours}{This is a vector of all possible mutants that we're trying to querry within the fitness landscape database.}

\item{tmp_focal_numMuts}{This is the number of mutations in the focal genotype, it controls - along with other parameters -
what tables of the fitness landscape database are querried.}

\item{tmp_refTables}{This is the a vector of named tables that exist within the fitness landscape.  It can not be passed
in which case the database at tmp_genCon is querried for this information.}

\item{maxHamming}{The maximum number of sites that could be changed by mutation of the tmp_focalGenotype.}

\item{tmp_tableSplit}{This is a logical which controls if the tables which report on all genotypes with X mutations should be
forced into a single table or it SHAPE is allowed to split them into multiple tables.}

\item{tmp_genomeLength}{The length of the genomes, or number of mutable sites/positions, being simulated.}

\item{tmpDirection}{This is a logical which controls if reversions are allowed (ie: if TRUE sites can revert from mutated to WT)}

\item{tmpRange_numMuts}{This is the range of number of mutations which a mutant neighbour may posses.  If not supplied that will
be calculated in line via other parameters passed to the function.}

\item{tmp_genCon}{This is the filepath for the database file that contains the fitness landscape information.}
}
\value{
A vector of the genotypes that need to be created as they've not yet been defined within the fitness landscape.
}
\description{
This function querries if a suite of genotypes exist within the fitness landscape database.
}
\section{Note}{

There is no example as this cannot work outisde of a runSHAPE call, it requires data produced by the simulation experiment.
}

