% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{name_batchString}
\alias{name_batchString}
\title{This function is used to build or split character string to be used for naming batches of SHAPE runs.}
\usage{
name_batchString(funcBase, func_setID = NULL, func_jobID = NULL,
  func_repID = NULL, funcSplit = FALSE,
  func_sepString = getOption("shape_sepString"))
}
\arguments{
\item{funcBase}{If building names this is the basal string element prefixing the name.  If splitting, it is the vector of names to be split.}

\item{func_setID}{If building names, a vector of the unique set IDs to be named, otherwise a logical of whether or not the batch naming structure includes sets}

\item{func_jobID}{If building names, a vector of the unique job IDs to be named, otherwise a logical of whether or not the batch naming structure includes jobs}

\item{func_repID}{If building names, a vector of the unique replicate IDs to be named, otherwise a logical of whether or not the batch naming structure includes replicates}

\item{funcSplit}{Logical toggle TRUE if splitting names, FALSE to build string characters}

\item{func_sepString}{This is the standard string separator for the SHAPE run}
}
\value{
Either a vector of character strings for the created batch names, or a matrix with the decomposed
elements of the split batch name strings
}
\description{
This function is used to build or split character string to be used for naming batches of SHAPE runs.
}
\examples{
# This simply produces or splits a standard named string.
name_batchString("myTest",1,9,3,FALSE,"_")
name_batchString("myTest_1_9_3",TRUE,TRUE,TRUE,TRUE,"_")

}
