% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intrinsic.R
\name{intrinsic.matern.operators}
\alias{intrinsic.matern.operators}
\title{Covariance-based approximations of intrinsic fields}
\usage{
intrinsic.matern.operators(
  kappa,
  tau,
  alpha,
  beta = 1,
  G = NULL,
  C = NULL,
  d = NULL,
  mesh = NULL,
  graph = NULL,
  loc_mesh = NULL,
  m_alpha = 2,
  m_beta = 2,
  compute_higher_order = FALSE,
  return_block_list = FALSE,
  type_rational_approximation = c("brasil", "chebfun", "chebfunLB"),
  fem_mesh_matrices = NULL,
  scaling = NULL,
  opts = NULL
)
}
\arguments{
\item{kappa}{range parameter}

\item{tau}{precision parameter}

\item{alpha}{Smoothness parameter}

\item{beta}{Smoothness parameter}

\item{G}{The stiffness matrix of a finite element discretization
of the domain of interest.}

\item{C}{The mass matrix of a finite element discretization of
the domain of interest.}

\item{d}{The dimension of the domain.}

\item{mesh}{An inla mesh.}

\item{graph}{An optional \code{metric_graph} object. Replaces \code{d}, \code{C} and \code{G}.}

\item{loc_mesh}{locations for the mesh for \code{d=1}.}

\item{m_alpha}{The order of the rational approximation for the Matérn part,
which needs to be a positive integer. The default value is 2.}

\item{m_beta}{The order of the rational approximation for the intrinsic part,
which needs to be a positive integer. The default value is 2.}

\item{compute_higher_order}{Logical. Should the higher order finite
element matrices be computed?}

\item{return_block_list}{Logical. For \code{type = "covariance"},
should the block parts of the precision matrix be returned
separately as a list?}

\item{type_rational_approximation}{Which type of rational
approximation should be used? The current types are
"brasil", "chebfun" or "chebfunLB".}

\item{fem_mesh_matrices}{A list containing FEM-related matrices.
The list should contain elements c0, g1, g2, g3, etc.}

\item{scaling}{scaling factor, see details.}

\item{opts}{options for numerical calulcation of the scaling, see details.}
}
\value{
\code{intrinsic.matern.operators} returns an object of
class "intrinsicCBrSPDEobj". This object is a list including the
following quantities:
\item{C}{The mass lumped mass matrix.}
\item{Ci}{The inverse of \code{C}.}
\item{GCi}{The stiffness matrix G times \code{Ci}}
\item{Q}{The precision matrix.}
\item{Q_list}{A list containing the blocks required to assemble the precision matrix.}
\item{alpha}{The fractional power of the Matérn part of the operator.}
\item{beta}{The fractional power of the intrinsic part of the operator.}
\item{kappa}{Range parameter of the covariance function}
\item{tau}{Scale parameter of the covariance function.}
\item{m_alpha}{The order of the rational approximation for the Matérn part.}
\item{m_beta}{The order of the rational approximation for the intrinsic part.}
\item{m}{The total number of blocks in the precision matrix.}
\item{n}{The number of mesh nodes.}
\item{d}{The dimension of the domain.}
\item{type_rational_approximation}{String indicating the type of rational approximation.}
\item{higher_order}{Boolean indicating if higher order FEM-related matrices are computed.}
\item{return_block_list}{Boolean indicating if the precision matrix is returned as
a list with the blocks.}
\item{fem_mesh_matrices}{A list containing the mass lumped mass
matrix, the stiffness matrix and
the higher-order FEM-related matrices.}
\item{make_A}{A function to compute the projection matrix which links the field to observation locations.}
\item{variogram}{A function to compute the variogram of the model at a specified node.}
\item{A}{Matrix that sums the components in the approximation to the mesh nodes.}
\item{scaling}{The scaling used in the intrinsic part of the model.}
}
\description{
\code{intrinsic.matern.operators} is used for computing a
covariance-based rational SPDE approximation of intrinsic
fields on \eqn{R^d} defined through the SPDE
\deqn{(-\Delta)^{\beta/2}(\kappa^2-\Delta)^{\alpha/2} (\tau u) = \mathcal{W}}{(-\Delta)^{\beta/2}(\kappa^2-\Delta)^{\alpha/2} (\tau u) = \mathcal{W}}
}
\details{
The covariance operator
\deqn{\tau^{-2}(-\Delta)^{\beta}(\kappa^2-\Delta)^{\alpha}}{\tau^{-2}(-\Delta)^{\beta}(\kappa^2-\Delta)^{\alpha}}
is approximated based on rational approximations of the two fractional
components. The Laplacians are equipped with homogeneous Neumann boundary
conditions. Unless supplied, the scaling is computed as the lowest positive eigenvalue of
\code{sqrt(solve(c0))\%*\%g1\%*\%sqrt(solve(c0))}. opts provides a list of options for the
numerical calculation of the scaling factor, which is done using \code{Rspectra::eigs_sym}.
See the help of that function for details.
}
\examples{
if (requireNamespace("RSpectra", quietly = TRUE)) {
  x <- seq(from = 0, to = 10, length.out = 201)
  beta <- 1
  alpha <- 1
  kappa <- 1
  op <- intrinsic.matern.operators(
    kappa = kappa, tau = 1, alpha = alpha,
    beta = beta, loc_mesh = x, d = 1
  )
  # Compute and plot the variogram of the model
  Sigma <- op$A[,-1] \%*\% solve(op$Q[-1,-1], t(op$A[,-1]))
  One <- rep(1, times = ncol(Sigma))
  D <- diag(Sigma)
  Gamma <- 0.5 * (One \%*\% t(D) + D \%*\% t(One) - 2 * Sigma)
  k <- 100
  plot(x, Gamma[k, ], type = "l")
  lines(x,
    variogram.intrinsic.spde(x[k], x, kappa, alpha, beta, L = 10, d = 1),
    col = 2, lty = 2
  )
}
}
