% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rspde_lme.R
\name{rspde_lme}
\alias{rspde_lme}
\title{rSPDE linear mixed effects models}
\usage{
rspde_lme(
  formula,
  loc,
  loc_time = NULL,
  data,
  model = NULL,
  repl = NULL,
  which_repl = NULL,
  optim_method = "L-BFGS-B",
  possible_methods = c("L-BFGS-B", "Nelder-Mead"),
  use_data_from_graph = TRUE,
  rspde_order = NULL,
  mean_correction = FALSE,
  previous_fit = NULL,
  fix_coeff = FALSE,
  model_options = list(),
  smoothness_upper_bound = 4,
  parallel = FALSE,
  n_cores = parallel::detectCores() - 1,
  optim_controls = list(),
  improve_hessian = FALSE,
  hessian_args = list(),
  alpha = lifecycle::deprecated(),
  nu = lifecycle::deprecated(),
  beta = lifecycle::deprecated(),
  starting_values_latent = lifecycle::deprecated(),
  start_sigma_e = lifecycle::deprecated(),
  start_alpha = lifecycle::deprecated(),
  start_nu = lifecycle::deprecated(),
  start_beta = lifecycle::deprecated(),
  nu_upper_bound = lifecycle::deprecated()
)
}
\arguments{
\item{formula}{Formula object describing the relation between the response
variables and the fixed effects. If the response variable is a matrix, each
column of the matrix will be treated as a replicate.}

\item{loc}{A vector with the names of the columns in \code{data} that contain the
observation locations, or a \code{matrix} or a \code{data.frame} containing the
observation locations. If the model is of class \code{metric_graph}, the locations
must be either a \code{matrix} or a \code{data.frame} with two columns, or a character
vector with the names of the two columns. The first column being the number of
the edge, and the second column being the normalized position on the edge.
If the model is a 2d model, \code{loc} must be either a \code{matrix} or \code{data.frame}
with two columns or a character vector with the name of the two columns that
contain the location, the first entry corresponding to the \code{x} entry and the
second corresponding to the \code{y} entry.}

\item{loc_time}{For spatio-temporal models, the name of the column in \code{data} that
is the time variable, or a \code{matrix} or \code{vector} containing the observation time
points.}

\item{data}{A \code{data.frame} containing the data to be used.}

\item{model}{Object generated by \code{matern.operators()}, \code{spde.matern.operators()}
or \code{spacetime.operators()}. If \code{NULL}, simple linear regression will be performed.}

\item{repl}{Vector indicating the replicate of each observation.
If \code{NULL} it will assume there is only one replicate. If the model is generated from graphs from
\code{metric_graph} class and \code{use_data_from_graph} is \code{TRUE}, \code{repl} needs to be the name of the
column inside the metric graph data that contains the replicate. If \code{NULL} it will assume there is only
one replicate.}

\item{which_repl}{Which replicates to use? If \code{NULL} all replicates will be used.}

\item{optim_method}{The method to be used with \code{optim} function.}

\item{possible_methods}{The optimization methods to try if the model fitting fails.}

\item{use_data_from_graph}{Logical. Only for models generated from graphs from
\code{metric_graph} class. In this case, should the data, the locations and the
replicates be obtained from the graph object?}

\item{rspde_order}{The order of the rational approximation to be used while
fitting the model. If not given, the order from the model object will be used.
Not used for spatio-temporal models.}

\item{mean_correction}{If TRUE, use mean correction for intrinsic models. Default FALSE.}

\item{previous_fit}{An object of class \code{rspde_lme}. Use the fitted coefficients as starting values.}

\item{fix_coeff}{If using a previous fit, should all coefficients be fixed at the starting values?}

\item{model_options}{A list containing additional options to be used in the model. This will take preference over the values extracted from previous_fit. Currently, it is possible to fix parameters during the estimation or change the starting values of the parameters. The general structure of the elements of the list is \code{fix_parname} and \code{start_parname}, where \code{parname} stands for the name of the parameter. If \code{fix_parname} is not \code{NULL}, then the model will be fitted with the \code{parname} being fixed at the value that was passed. If \code{start_parname} is not \code{NULL}, the model will be fitted using the value passed as starting value for \code{parname}. For 'rSPDE' and 'rSPDE1d' models, the possible elements of the list are \code{fix_sigma_e}, \code{start_sigma_e}, \code{fix_nu}, \code{start_nu}, \code{fix_sigma}, \code{start_sigma}, \code{fix_range}, \code{start_range}. Alternatively, one can also use the elements \code{fix_sigma_e}, \code{start_sigma_e}, \code{fix_nu}, \code{start_nu}, \code{fix_tau}, \code{start_tau}, \code{fix_kappa}, \code{start_kappa}. For 'spacetime' models, the possible elements of the list are \code{fix_sigma_e}, \code{start_sigma_e}, \code{fix_kappa}, \code{start_kappa}, \code{fix_sigma}, \code{start_sigma}, \code{fix_gamma}, \code{start_gamma}, \code{fix_rho}, \code{start_rho}. For dimension 2, the second coordinate of \code{rho} has name \code{rho2} and must be passed as \code{start_rho2} and \code{fix_rho2}. For 'rSPDE2d' models, the possible elements of the list are \code{fix_sigma_e}, \code{start_sigma_e}, \code{fix_nu}, \code{start_nu}, \code{fix_sigma}, \code{start_sigma}, \code{fix_hx}, \code{start_hx}, \code{fix_hy}, \code{start_hy}, \code{fix_hxy}, \code{start_hxy}. For nonstationary models, we have two options: the first is to pass the starting values as a vector with name \code{start_theta} and a vector with the names of the parameters to be fixed with name    \code{fix_theta}; the second option is to handle the individual parameters, by passing the names \code{thetan} where \code{n} is the number of the parameter to pass the starting value or to be fixed. For example, to pass the starting value for \code{theta3} one simply pass \code{start_theta3}, and to fix \code{theta2}, one simply pass \code{fix_theta2}.}

\item{smoothness_upper_bound}{Upper bound for \code{nu}, when \code{nu} is the smoothness parameter, or for \code{alpha - d/2} when \code{alpha} is the smoothness parameter, or for \verb{max\\\{alpha - d/2, beta - d/2)} for intrinsic models.}

\item{parallel}{logical. Indicating whether to use optimParallel or not.}

\item{n_cores}{Number of cores to be used if parallel is true.}

\item{optim_controls}{Additional controls to be passed to \code{optim} or \code{optimParallel}.}

\item{improve_hessian}{Should a more precise estimate of the hessian be obtained?
Turning on might increase the overall time.}

\item{hessian_args}{List of controls to be used if \code{improve_hessian} is \code{TRUE}.
The list can contain the arguments to be passed to the \code{method.args} argument
in the \code{numDeriv::hessian} function. See the help of the \code{hessian} function in
\code{numDeriv} package for details. Observe that it only accepts the "Richardson"
method for now, the method "complex" is not supported.}

\item{alpha}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{model_options} instead.}

\item{nu}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{model_options} instead.}

\item{beta}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{model_options} instead.}

\item{starting_values_latent}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{model_options} instead.}

\item{start_sigma_e}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{model_options} instead.}

\item{start_alpha}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{model_options} instead.}

\item{start_nu}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{model_options} instead.}

\item{start_beta}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{model_options} instead.}

\item{nu_upper_bound}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{smoothness_upper_bound} instead.}
}
\value{
A list containing the fitted model.
}
\description{
Fitting linear mixed effects model with latent Whittle-Matern models.
}
