% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplecodes.R
\name{simple_IDs}
\alias{simple_IDs}
\title{Simple color coding scheme generator}
\usage{
simple_IDs(total.length, alphabet, available.colors = NULL)
}
\arguments{
\item{total.length}{the number of unique positions to be marked on the animal. (This can be thought of as the total number of positions on which color bands or paint marks will be applied.)}

\item{alphabet}{an integer representing the 'alphabet size.' This is the number of unique markings (think different paint colors, symbols, or varieties of bands) at your disposal.}

\item{available.colors}{an optional list of strings that contains the names of the unique markings which compose the given 'alphabet' (e.g. "blue", "red", "yellow", etc.). If left blank, the mapping can be done at any later time using \code{\link{codes_to_colors}}. Additionally, the length of this list must match the 'alphabet size' given above.}
}
\value{
a list containing the maximum possible number of unique ID codes that fit the provided parameters.

If an appropriate argument for \code{available.colors} is provided, each code will be a sequence of strings, otherwise, each code will be a sequence of numeric values.
}
\description{
Creates a simple color (or symbol) coding scheme used to mark and identify individual animals. The sum of each IDs numeric sequence is a multiple of the number of colors used in the scheme. Even if one marking is removed, the entire ID code can be reconstructed.
}
\examples{
total.length <- 4  #we have four positions to mark
alphabet <- 5      #and we currently have five types of paint in stock

 #Generate codes where the sum of the sequence is a multiple of five
simple_IDs(total.length, alphabet)

 #Let's make those into human-readable color sequences
color.names <- c("blue","red","green","pink","cyan")
simple_IDs(total.length, alphabet, available.colors = color.names)

}
\references{
Burchill, A. T., & Pavlic, T. P. (2019). Dude, where's my mark? Creating robust animal identification schemes informed by communication theory. \emph{Animal Behaviour}, 154, 203-208. \href{https://doi.org/10.1016/j.anbehav.2019.05.013}{doi:10.1016/j.anbehav.2019.05.013}
}
\seealso{
\code{\link{rs_IDs}}, \code{\link{brute_IDs}}.
}
\author{
Andrew Burchill, \email{andrew.burchill@asu.edu}
}
