% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed.R
\name{embed_ollama}
\alias{embed_ollama}
\alias{embed_openai}
\alias{embed_lm_studio}
\title{Embed Text}
\usage{
embed_ollama(
  x,
  base_url = "http://localhost:11434",
  model = "snowflake-arctic-embed2:568m",
  batch_size = 10L
)

embed_openai(
  x,
  model = "text-embedding-3-small",
  base_url = "https://api.openai.com/v1",
  api_key = get_envvar("OPENAI_API_KEY"),
  dims = NULL,
  user = get_user(),
  batch_size = 20L
)

embed_lm_studio(
  x,
  model,
  base_url = "http://localhost:1234/v1",
  api_key = "lm-studio",
  dims = NULL,
  user = get_user(),
  batch_size = 20L
)
}
\arguments{
\item{x}{x can be:
\itemize{
\item A character vector, in which case a matrix of embeddings is returned.
\item A data frame with a column named \code{text}, in which case the dataframe is
returned with an additional column named \code{embedding}.
\item Missing or \code{NULL}, in which case a function is returned that can be called
to get embeddings. This is a convenient way to partial in additional arguments like \code{model},
and is the most convenient way to produce a function that can be passed to the \code{embed} argument of \code{ragnar_store_create()}.
}}

\item{base_url}{string, url where the service is available.}

\item{model}{string; model name}

\item{batch_size}{split \code{x} into batches when embedding. Integer, limit of
strings to include in a single request.}

\item{api_key}{resolved using env var \code{OPENAI_API_KEY}}

\item{dims}{An integer, can be used to truncate the embedding to a specific size.}

\item{user}{User name passed via the API.}
}
\value{
If \code{x} is a character vector, then a numeric matrix is returned,
where \code{nrow = length(x)} and \verb{ncol = <model-embedding-size>}. If \code{x} is a
data.frame, then a new \code{embedding} matrix "column" is added, containing the
matrix described in the previous sentence.

A matrix of embeddings with 1 row per input string, or a dataframe with an 'embedding' column.
}
\description{
Embed Text
}
\section{Functions}{
\itemize{
\item \code{embed_lm_studio()}: Embed Text using LMStudio. Indentical to \code{embed_openai()} but with suitable defaults for LMStudio.

}}
\examples{
text <- c("a chunk of text", "another chunk of text", "one more chunk of text")
\dontrun{
text |>
  embed_ollama() |>
  str()

text |>
  embed_openai() |>
  str()
}
}
