% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agg.R
\name{agg}
\alias{agg}
\title{Aggregation using box-averaging}
\usage{
agg(z, nas)
}
\arguments{
\item{z}{matrix containing the fine field to aggregate.}

\item{nas}{target dimension for the output field.}
}
\value{
The coarse field obtained by box averaging.
}
\description{
Aggregates an input field \code{z} to an array at
coarser resolutions \code{c(nas,nas)} by box averaging.
The input array can contain missing values.
}
\examples{
z <- rnorm(64 * 64)
dim(z) <- c(64, 64)
za <- agg(z, 4)
dim(za)
# [1] 4 4
}
\author{
Jost von Hardenberg, \email{j.vonhardenberg@isac.cnr.it}
}
