% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussianize.R
\name{gaussianize}
\alias{gaussianize}
\title{Gaussianize field using rank ordering}
\usage{
gaussianize(z)
}
\arguments{
\item{z}{matrix containing the input field to be Gaussianized.}
}
\value{
The Gaussianized field with the same dimensions as the input field.
}
\description{
The amplitudes of the input field are rank ordered and
substituted with the corresponding rank-ordered samples from a
Normal distribution.
}
\examples{
# Make some sample synthetic rainfall data
r <- exp(rnorm(64 * 64))
dim(r) <- c(64, 64)
# Gaussianize and check standard deviation
g <- gaussianize(r)
sd(g)
# [1] 1
}
\author{
Jost von Hardenberg, \email{j.vonhardenberg@isac.cnr.it}
}
