% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ramchoice-package.R
\docType{package}
\name{ramchoice-package}
\alias{ramchoice}
\alias{ramchoice-package}
\title{ramchoice: Revealed Preference and Attention Analysis in Random Limited Attention Models}
\description{
Information about socio-economic agent's preference (consumer,
  firm, organization, voter, etc.) is important not only for understanding
  the decision-making process, but also for conducting welfare analysis and
  providing robust policy recommendations. However, it is widely documented in
  psychology, economics and other disciplines that decision makers may not pay
  full attention to all available alternatives, rendering standard revealed
  preference theory invalid.

This package implements the estimation and inference procedures documented in
  \href{https://arxiv.org/abs/1712.03448}{Cattaneo, Ma, Masatlioglu, and Suleymanov (2020)},
  and \href{https://arxiv.org/abs/2110.10650}{Cattaneo, Cheung, Ma, and Masatlioglu (2024)},
  which utilize standard choice data to partially identify decision
  maker's preference and attention. For statistical inference, several simulation-based
  critical values are provided.

  The following functions are provided: \code{\link{revealPref}} and \code{\link{revealAtte}}
  (the main functions for revealed preference and attention analysis),
  \code{\link{sumData}}, \code{\link{genMat}}, \code{\link{logitAtte}}, \code{\link{logitSimu}}.
  A simulated dataset \code{\link{ramdata}} is also included for illustration purposes.
}
\references{
M. D. Cattaneo, X. Ma, Y. Masatlioglu, and E. Suleymanov (2020). \href{https://arxiv.org/abs/1712.03448}{A Random Attention Model}. \emph{Journal of Political Economy} 128(7): 2796-2836. \doi{10.1086/706861}

M. D. Cattaneo, P. Cheung, X. Ma, and Y. Masatlioglu (2024). \href{https://arxiv.org/abs/2110.10650}{Attention Overload}. Working paper.
}
\author{
Matias D. Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Paul Cheung, University of Maryland. \email{hycheung@umd.edu}

Xinwei Ma (maintainer), University of California San Diego. \email{x1ma@ucsd.edu}

Yusufcan Masatlioglu, University of Maryland. \email{yusufcan@umd.edu}

Elchin Suleymanov, Purdue University. \email{esuleyma@purdue.edu}
}
