% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibramp.R
\name{expand}
\alias{expand}
\title{Create a calibrated color ramp object from color-tiepoint data.frames}
\usage{
expand(x = NULL, n, color = "color", z = "z", ...)
}
\arguments{
\item{x}{A \code{data.frame} object with two columns: \code{color} for hexadecimal color values, \code{z} for their position.}

\item{n}{A single \code{integer} number.}

\item{color}{A \code{chraracter} value, the column name of the colors in \code{x}, defaults to \code{"color"}. Alternatively, a \code{character} vector of hexadecimal color values, with the same length as \code{z}.}

\item{z}{A \code{character} value, the column name of the values in \code{x}, defaults to \code{"z"}. Alternatively, a \code{numeric} vector of color values (must have the same length as \code{color}.}

\item{...}{Arguments passed to the \code{colorRampPalette} function.}
}
\value{
A \code{calibramp}-class object (see description above).
}
\description{
Create ramp palettes from fixed color positions.
}
\details{
The function creates objects of the S3 class \code{calibramp}. The \code{calibramp}-class lists have three elements: \code{col} hexadecimal color values, \code{mid}: z-values of midpoints (one for every color), and \code{breaks}: separator borders between color values.
Color interpolation will be executed linearly, using \code{\link[grDevices]{colorRampPalette}}, the order of the values will be forced to ascending, the values in \code{mid} will be halfway between breaks.
}
\examples{
library(rampage)
data(topos)
ramp <- expand(topos$havanna2, n=200)
plot(ramp)

}
