% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\docType{data}
\name{topos}
\alias{topos}
\title{Topographic color palettes with tiepoints}
\format{
A \code{list} with 6 \code{data.frame} elements:
\describe{
\item{\code{demcmap}}{: The "demcmap" theme, based on MatLab's \code{demcmap}. }
\item{\code{etopo}}{: The "etopo" theme, approximate elevation-color assignments based on the the ETOPO Global Relief Model poster (https://www.ncei.noaa.gov/media/3340). }
\item{\code{jakarta}}{: The "Jakarta" theme, color values by Deviantart user \emph{Arcanographia}. }
\item{\code{havanna2}}{: The "Havanna-2" theme, color values by Deviantart user \emph{Arcanographia}.}
\item{\code{tokio1}}{: The "Tokio-1" theme, color values by Deviantart user \emph{Arcanographia}.}
\item{\code{zagreb}}{: The "Zagreb" theme, color values by Deviantart user \emph{Arcanographia}.}
}
}
\usage{
data(topos)
}
\description{
The object contains \code{data.frame}-class objects to be used with the \code{\link{expand}} function to produce full calibrated color ramps.
}
\examples{
data(topos)
jakExp <- expand(topos$jakarta, n=200)
plot(jakExp)
}
\keyword{datasets}
