\name{randnet-package}
\alias{randnet-package}
\alias{randnet}
\docType{package}
\title{
Statistical modeling of random networks with model estimation, selection and
parameter tuning
}
\description{
The package provides model fitting and estimation functions for some
popular random network models. More importantly, it implements a general
cross-validation framework for model selection and parameter tuning
called ECV. Several other model selection methods are also included.
The work to build and improve this package is partially supported by the NSF
grants DMS-2015298 and DMS-2015134.
}
\details{
\tabular{ll}{
Package: \tab randnet\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2025-07-28\cr
License: \tab GPL (>= 2)\cr
}
}
\author{
  Tianxi Li, Elizaveta Levina, Ji Zhu, Can M. Le\cr

Maintainer: Tianxi Li <tianxili@umn.edu>

}
\references{
  T. Li, E. Levina, and J. Zhu. Network cross-validation by edge
  sampling. Biometrika, 107(2), pp.257-276, 2020.

  K. Chen and J. Lei. Network cross-validation for determining the number
  of communities in network data. Journal of the American Statistical
  Association, 113(521):241-251, 2018.

  K. Rohe, S. Chatterjee, and B. Yu. Spectral clustering and the
high-dimensional stochastic blockmodel. The Annals of Statistics, pages
1878-1915, 2011.

  A. A. Amini, A. Chen, P. J. Bickel, and E. Levina. Pseudo-likelihood
  methods for community detection in large sparse networks. The Annals
  of Statistics, 41(4):2097-2122, 2013.

  Qin, T. & Rohe, K. Regularized spectral clustering under the degree-corrected stochastic blockmodel Advances in Neural Information Processing Systems, 2013, 3120-3128

  J. Lei and A. Rinaldo. Consistency of spectral clustering in stochastic block models. The
  Annals of Statistics, 43(1):215-237, 2014.

  C. M. Le, E. Levina, and R. Vershynin. Concentration and regularization of random graphs.
  Random Structures & Algorithms, 2017.

  S. J. Young and E. R. Scheinerman. Random dot product graph models for
  social networks. In International Workshop on Algorithms and Models
  for the Web-Graph, pages 138-149. Springer, 2007.

  C. M. Le and E. Levina. Estimating the number of communities in networks by spectral
methods. arXiv preprint arXiv:1507.00827, 2015.

  Zhang, Y.; Levina, E. & Zhu, J. Estimating network edge probabilities by neighbourhood smoothing Biometrika, Oxford University Press, 2017, 104, 771-783


  B. Karrer and M. E. Newman. Stochastic blockmodels and community structure in networks.
  Physical Review E, 83(1):016107, 2011.

  Wang, Y. R. & Bickel, P. J. Likelihood-based model selection for
  stochastic block models The Annals of Statistics, Institute of
  Mathematical Statistics, 2017, 45, 500-528

  Gao, C.; Ma, Z.; Zhang, A. Y. & Zhou, H. H. Achieving optimal misclassification proportion in stochastic block models The Journal of Machine Learning Research, JMLR. org, 2017, 18, 1980-2024
  
    Li, T., Levina, E. and Zhu, J., 2023. Community models for networks observed through edge nominations. Journal of Machine Learning Research, 24(282), pp.1-36.

Li, T. and Le, C.M., 2024. Network estimation by mixing: Adaptivity and more. Journal of the American Statistical Association, 119(547), pp.2190-2205.

Miao, R. and Li, T., 2023. Informative core identification in complex networks. Journal of the Royal Statistical Society Series B: Statistical Methodology, 85(1), pp.108-126.

  Sischka, B. and Kauermann, G., 2022. EM-based smooth graphon estimation using MCMC and spline-based approaches. Social Networks, 68, pp.279-295.
  
  Ma, Z., Ma, Z. and Yuan, H., 2020. Universal latent space model fitting for large networks with edge covariates. Journal of Machine Learning Research, 21(4), pp.1-67.
}
\keyword{ package }


