% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default_n.R
\name{default_n}
\alias{default_n}
\alias{blueprint_n}
\alias{tibble_n}
\alias{dplyr_n}
\alias{args_n}
\title{Find the Default Value for n in Context}
\usage{
default_n(...)

blueprint_n()

tibble_n()

dplyr_n()

args_n(...)
}
\arguments{
\item{...}{parameters to check the lengths of}
}
\value{
The context aware value for n
}
\description{
Checks for various information surrounding the call to this function
to figure out what value for n should be used
}
\details{
The \code{default_n()} function will run through the other
functions found here until it finds a viable value for n. \cr\cr
It first checks for contxt to see if calls external to \code{default_n()}
indicate which value should be used:
\itemize{
\item \code{blueprint_n()} - Checks if the function is being called
within a blueprinting function, and returns the value supplied to
that function, see \code{\link[=blueprint]{blueprint()}}.
\item \code{tibble_n()} - Checks if the function is being called
within the declaration of a tibble. It then checks the lengths of
the other arguments being passed to the call. If you want to
specify how many rows should be generate you can use the \code{.rows}
argument in your \code{tibble()} call, see \code{\link[tibble:tibble]{tibble()}}
\item \code{dplyr_n()} - Checks if the function is being used within a
\code{\link[dplyr:dplyr-package]{dplyr}} verb, if so, it returns the value of
\code{\link[dplyr:context]{n()}}
}

It then checks the lengths of the arguments supplied via \code{...},
if there is a discrepancy between these arguments and the context
aware value found above, it will throw an error.

If all the above values return \code{1} or \code{NULL}, we then check for
a global n assigned by \code{\link[=set_n]{set_n()}}, if none is set then \code{default_n()}
will return \code{1}.
}
\examples{
# Global Values:
set_n(NULL)
default_n()
set_n(10)
default_n()

# In a blueprint:
bp <- blueprint(x=r_norm(),n=default_n())
bp(n=7)
bp <- blueprint(x=r_norm(),n=blueprint_n())
bp(n=8)

# In a tibble:
tibble::tibble(id = 1:3, n = default_n())
tibble::tibble(id = 1:5, n = tibble_n())

# In a dplyr verb:
df <- tibble::tibble(id = 1:4)
dplyr::mutate(df, n = default_n())
dplyr::mutate(df, n = dplyr_n())

# From arguments:
default_n(1:5)
default_n(1:5,c("a","b","c","d","e"))
args_n(1:3,c("a","b","d"))
args_n(1:3, 1:4)

\dontrun{
default_n(1:3, 1:4)
tibble::tibble(id=1:5,n=default_n(1:4))
}

}
