% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is_wholenumber}
\alias{is_wholenumber}
\title{Check if a Number is Whole}
\usage{
is_wholenumber(x, tol = .Machine$double.eps^0.5)
}
\arguments{
\item{x}{Number to check}

\item{tol}{tolerance to check the values}
}
\value{
A logical vector the same length as \code{x}
}
\description{
The built-in function \code{is.integer()} will check if a number is of
the \code{integer} class. However, we would usually want a function
that can check if a number is a \emph{whole number}. It is also
vectorised over the input.
}
\examples{
is.integer(2)
is_wholenumber(2)

is.integer(seq(2, 3, 0.25))
is_wholenumber(seq(2, 3, 0.25))
}
