% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{apply_metadata}
\alias{apply_metadata}
\title{Apply Metadata}
\usage{
apply_metadata(
  df,
  filename,
  add_adsl = TRUE,
  adsl_filename = "metadata/ADSL.yml"
)
}
\arguments{
\item{df}{(\code{data.frame})\cr Data frame to which metadata is applied.}

\item{filename}{(\code{yaml})\cr File containing domain metadata.}

\item{add_adsl}{(\code{logical})\cr Should ADSL data be merged to domain.}

\item{adsl_filename}{(\code{yaml})\cr File containing ADSL metadata.}
}
\value{
Data frame with metadata applied.
}
\description{
Apply label and variable ordering attributes to domains.
}
\examples{
seed <- 1
adsl <- radsl(seed = seed)
adsub <- radsub(adsl, seed = seed)
yaml_path <- file.path(path.package("random.cdisc.data"), "inst", "metadata")
adsl <- apply_metadata(adsl, file.path(yaml_path, "ADSL.yml"), FALSE)
adsub <- apply_metadata(
  adsub, file.path(yaml_path, "ADSUB.yml"), TRUE,
  file.path(yaml_path, "ADSL.yml")
)
}
