% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mutate_na}
\alias{mutate_na}
\title{Replace Values with NA}
\usage{
mutate_na(ds, na_vars = NULL, na_percentage = 0.05)
}
\arguments{
\item{ds}{(\code{data.frame})\cr Any data set.}

\item{na_vars}{(\code{list})\cr A named list where the name of each element is a column name of \code{ds}. Each
element of this list should be a numeric vector with two elements:
\itemize{
\item{\code{seed} (\code{numeric})\cr The seed to be used for this element - can be \code{NA}.}
\item{\code{percentage} (\code{proportion})\cr Percentage of elements to be replaced with \code{NA}.
If \code{NA}, \code{na_percentage} is used as a default.}
}}

\item{na_percentage}{(\code{proportion})\cr Default percentage of values to be replaced by \code{NA}.}
}
\value{
dataframe without \code{NA} values.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Replace column values with \code{NA}s.
}
