% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radae.R
\name{radae}
\alias{radae}
\title{Adverse Event Analysis Dataset (ADAE)}
\usage{
radae(
  adsl,
  max_n_aes = 10L,
  lookup = NULL,
  lookup_aag = NULL,
  seed = NULL,
  na_percentage = 0,
  na_vars = list(AEBODSYS = c(NA, 0.1), AEDECOD = c(1234, 0.1), AETOXGR = c(1234, 0.1)),
  cached = FALSE
)
}
\arguments{
\item{adsl}{(\code{data.frame})\cr Subject-Level Analysis Dataset (ADSL).}

\item{max_n_aes}{(\code{integer})\cr Maximum number of AEs per patient. Defaults to 10.}

\item{lookup}{(\code{data.frame})\cr Additional parameters.}

\item{lookup_aag}{(\code{data.frame})\cr Additional metadata parameters.}

\item{seed}{(\code{numeric})\cr Seed to use for reproducible random number generation.}

\item{na_percentage}{(\code{proportion})\cr Default percentage of values to be replaced by \code{NA}.}

\item{na_vars}{(\code{list})\cr A named list where the name of each element is a column name of \code{ds}. Each
element of this list should be a numeric vector with two elements:
\itemize{
\item{\code{seed} (\code{numeric})\cr The seed to be used for this element - can be \code{NA}.}
\item{\code{percentage} (\code{proportion})\cr Percentage of elements to be replaced with \code{NA}.
If \code{NA}, \code{na_percentage} is used as a default.}
}}

\item{cached}{boolean whether the cached ADAE data \code{cadae} should be returned or new data
should be generated. If set to \code{TRUE} then the other arguments to \code{radae} will be ignored.}
}
\value{
\code{data.frame}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Function for generating random Adverse Event Analysis Dataset for a given
Subject-Level Analysis Dataset.
}
\details{
One record per each record in the corresponding SDTM domain.

Keys: \code{STUDYID}, \code{USUBJID}, \code{ASTDTM}, \code{AETERM}, \code{AESEQ}
}
\examples{
adsl <- radsl(N = 10, study_duration = 2, seed = 1)

adae <- radae(adsl, seed = 2)
adae

# Add metadata.
aag <- utils::read.table(
  sep = ",", header = TRUE,
  text = paste(
    "NAMVAR,SRCVAR,GRPTYPE,REFNAME,REFTERM,SCOPE",
    "CQ01NAM,AEDECOD,CUSTOM,D.2.1.5.3/A.1.1.1.1 AESI,dcd D.2.1.5.3,",
    "CQ01NAM,AEDECOD,CUSTOM,D.2.1.5.3/A.1.1.1.1 AESI,dcd A.1.1.1.1,",
    "SMQ01NAM,AEDECOD,SMQ,C.1.1.1.3/B.2.2.3.1 AESI,dcd C.1.1.1.3,BROAD",
    "SMQ01NAM,AEDECOD,SMQ,C.1.1.1.3/B.2.2.3.1 AESI,dcd B.2.2.3.1,BROAD",
    "SMQ02NAM,AEDECOD,SMQ,Y.9.9.9.9/Z.9.9.9.9 AESI,dcd Y.9.9.9.9,NARROW",
    "SMQ02NAM,AEDECOD,SMQ,Y.9.9.9.9/Z.9.9.9.9 AESI,dcd Z.9.9.9.9,NARROW",
    sep = "\n"
  ), stringsAsFactors = FALSE
)

adae <- radae(adsl, lookup_aag = aag)

with(
  adae,
  cbind(
    table(AEDECOD, SMQ01NAM),
    table(AEDECOD, CQ01NAM)
  )
)
}
