% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_importance.R
\name{plot_importance_ggpairs}
\alias{plot_importance_ggpairs}
\title{Plot importance measures with ggpairs}
\usage{
plot_importance_ggpairs(
  importance_frame,
  measures = NULL,
  main = "Relations between measures of importance"
)
}
\arguments{
\item{importance_frame}{A result of using the function measure_importance() to a random forest or a randomForest object}

\item{measures}{A character vector specifying the measures of importance to be used}

\item{main}{A string to be used as title of the plot}
}
\value{
A ggplot object
}
\description{
Plot selected measures of importance of variables in a forest using ggpairs
}
\examples{
forest <- randomForest::randomForest(Species ~ ., data = iris, localImp = TRUE, ntree = 200)
frame <- measure_importance(forest, measures = c("mean_min_depth", "times_a_root"))
plot_importance_ggpairs(frame, measures = c("mean_min_depth", "times_a_root"))

}
