% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aqs_dailydata.R
\name{aqs_dailydata}
\alias{aqs_dailydata}
\alias{dailydata_bysite}
\alias{dailydata_bycounty}
\alias{dailydata_bystate}
\alias{dailydata_bybox}
\alias{dailydata_bycbsa}
\title{AQS API Daily Summary Data service}
\usage{
aqs_dailydata(
  aqs_filter = c("bySite", "byCounty", "byState", "byBox", "byCBSA"),
  aqs_variables = NULL,
  header = FALSE,
  ...
)

dailydata_bysite(
  param,
  bdate,
  edate,
  state,
  county,
  site,
  email = get_aqs_email(),
  key = get_aqs_key(),
  duration = NULL,
  cbdate = NULL,
  cedate = NULL,
  header = FALSE,
  ...
)

dailydata_bycounty(
  param,
  bdate,
  edate,
  state,
  county,
  email = get_aqs_email(),
  key = get_aqs_key(),
  duration = NULL,
  cbdate = NULL,
  cedate = NULL,
  header = FALSE,
  ...
)

dailydata_bystate(
  param,
  bdate,
  edate,
  state,
  email = get_aqs_email(),
  key = get_aqs_key(),
  duration = NULL,
  cbdate = NULL,
  cedate = NULL,
  header = FALSE,
  ...
)

dailydata_bybox(
  param,
  bdate,
  edate,
  minlat,
  maxlat,
  minlon,
  maxlon,
  email = get_aqs_email(),
  key = get_aqs_key(),
  duration = NULL,
  cbdate = NULL,
  cedate = NULL,
  header = FALSE,
  ...
)

dailydata_bycbsa(
  param,
  bdate,
  edate,
  cbsa,
  email = get_aqs_email(),
  key = get_aqs_key(),
  duration = NULL,
  cbdate = NULL,
  cedate = NULL,
  header = FALSE,
  ...
)
}
\arguments{
\item{aqs_filter}{A string specifying one of the service filters. NOT
case-sensitive.}

\item{aqs_variables}{A named list of variables to fetch data (e.g.,
\code{state}). Only necessary variables are passed to a specific endpoint
(service/filter) to make a valid request.}

\item{header}{A logical specifying whether the function returns additional
information from the API header. Default is \code{FALSE} to return data only.}

\item{...}{Reserved for future use.}

\item{param}{A string or vector of strings specifying the 5-digit AQS
parameter code for data selection. An integer will be coerced to a string.
A maximum of 5 parameter codes may be listed in a single request. A list
of the parameter codes can be obtained via \link{list_parametersbyclass}.}

\item{bdate}{A string specifying the begin date of data selection in
YYYYMMDD format. Only data on or after this date will be returned.}

\item{edate}{A string specifying the end date of data selection in YYYYMMDD
format. Only data on or before this date will be returned. If the end date
is not in the same year as the begin date, the function will automatically
split the date range into multiple chunks by year and send requests
sequentially.}

\item{state}{A string specifying the 2-digit state FIPS code. An integer
will be coerced to a string with a leading zero if necessary (e.g., 1 ->
"01"). A list of the state codes can be obtained via \link{list_states}.}

\item{county}{A string specifying the 3-digit county FIPS code. An integer
will be coerced to a string with leading zeros if necessary (e.g., 89 ->
"089"). A list of the county codes within each state can be obtained via
\link{list_countiesbystate}.}

\item{site}{A string specifying the 4-digit AQS site number within the
county. An integer will be coerced to a string with leading zeros if
necessary (e.g., 14 -> "0014"). A list of the site codes within each
county can be obtained via \link{list_sitesbycounty}.}

\item{email}{A string specifying the email address of the requester. If you
set your email and key with \link{set_aqs_user}, you don't have to specify
this.}

\item{key}{A string specifying the key matching the email address for the
requester. If you set your email and key with \link{set_aqs_user}, you don't
have to specify this.}

\item{duration}{(optional) A string specifying the 1-character AQS sample
duration code. A list of the duration codes can be obtained via
\link{list_durations}. Only data reported at this sample duration will be
returned.}

\item{cbdate}{(optional) A string specifying the change begin date in
YYYYMMDD format to subset data based on "date of last change" in database.
Only data that changed on or after this date will be returned.}

\item{cedate}{(optional) A string specifying the change end date in YYYYMMDD
format to subset data based on "date of last change" in database. Only
data that changed on or before this date will be returned.}

\item{minlat}{A string or numeric value specifying the minimum latitude of a
geographic box. Decimal latitude with north being positive.}

\item{maxlat}{A string or numeric value specifying the maximum latitude of a
geographic box. Decimal latitude with north being positive.}

\item{minlon}{A string or numeric value specifying the minimum longitude of
a geographic box. Decimal longitude with east being positive.}

\item{maxlon}{A string or numeric value specifying the maximum longitude of
a geographic box. Decimal longitude with east being positive.}

\item{cbsa}{A string specifying the AQS CBSA code. A list of the CBSA codes
can be obtained via \link{list_cbsas}.}
}
\value{
A data.frame containing parsed data or a named list containing
header and data.
}
\description{
A collection of functions to fetch data summarized at the daily level.
Please use a narrow range of dates to adhere to the API's limit imposed on
request size.
}
\details{
\link{aqs_dailydata} sends a request to the AQS API based on a user-provided
filter using the following underlying functions:
\itemize{
\item \link{dailydata_bysite} returns daily summary \code{param} data for \code{site} in
\code{county}, within \code{state}, between \code{bdate} and \code{edate}.
\item \link{dailydata_bycounty} returns daily summary \code{param} data for \code{county} in
\code{state} between \code{bdate} and \code{edate}.
\item \link{dailydata_bystate} returns daily summary \code{param} data for \code{state} between
\code{bdate} and \code{edate}.
\item \link{dailydata_bybox} returns daily summary \code{param} data for a user-provided
latitude/longitude bounding box (\code{minlat}, \code{maxlat}, \code{minlon}, \code{maxlon})
between \code{bdate} and \code{edate}.
\item \link{dailydata_bycbsa} returns daily summary \code{param} data for a user-provided
CBSA between \code{bdate} and \code{edate}.
}
}
\examples{
\dontrun{

## Set your API Key first using set_aqs_user to run the following codes

## Example from the AQS website
## FRM/FEM PM2.5 data for Wake County, NC between Jan and Feb 2016
aqs_variables <- list(
  param = "88101", bdate = "20160101", edate = "20160228",
  state = "37", county = "183"
)
aqs_dailydata(aqs_filter = "byCounty", aqs_variables = aqs_variables)

## Equivalent to above; used integers instead of strings
dailydata_bycounty(
  param = 88101, bdate = "20160101", edate = "20160228",
  state = 37, county = 183
)
}

}
