% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_model.R
\name{fix}
\alias{fix}
\alias{fix.bi_model}
\title{Fix noise term, state or parameter of a libbi model}
\usage{
\method{fix}{bi_model}(x, ...)
}
\arguments{
\item{x}{a \code{\link{bi_model}} object}

\item{...}{values to be assigned to the (named) variables}
}
\value{
the updated \code{bi_model} object
}
\description{
Replaces all variables with fixed values as given ; note that this will not
  replace differential equations and lead to an error if applied to states
  that are changed inside an "ode" block

For the help page of the base R \code{fix} function, see
  \code{\link[utils]{fix}}.
}
\examples{
model_file_name <- system.file(package = "rbi", "PZ.bi")
PZ <- bi_model(filename = model_file_name)
PZ <- fix(PZ, alpha = 0)
}
\seealso{
\code{\link{bi_model}}
}
