test_that("Correlation", {
      # Very small fit to run super fast
      data("Male_Gammarus_Single")
      modelData_MGS <- modelData(Male_Gammarus_Single, time_accumulation = 4)
      fit_MGS <- rmMessWarn(
          fitTK(modelData_MGS, iter = 10, chains = 2, refresh = 0)
      )
      data("Male_Gammarus_seanine_growth")
      modelData_MGSG <- modelData(Male_Gammarus_seanine_growth, time_accumulation = 1.417)
      fit_MGSG <- rmMessWarn(
          fitTK(modelData_MGSG, iter = 10, chains=2, refresh = 0)
      )
  #test_that("corrMatrix",{
    matrix_MGS <- corrMatrix(fit_MGS)
    matrix_MGSG <- corrMatrix(fit_MGSG)
    
    # Check class
    expect_true(all(ggplot2::is_ggplot(matrix_MGS)))
    expect_true(all(ggplot2::is_ggplot(matrix_MGSG)))
  #})
  
  #test_that("corrPlot",{
      expect_no_error(plt_MGS <- corrPlot(fit_MGS))
      expect_no_error(plt_MGS_det <- corrPlot(fit_MGS,"deterministic"))
      expect_no_error(plt_MGSG <- corrPlot(fit_MGSG))
      expect_no_error(plt_MGSG_det <- corrPlot(fit_MGSG,"deterministic"))
      expect_no_error(plt_MGSG_sto <- corrPlot(fit_MGSG,"stochastic"))
  #})
})
