test_that("waic", {
  
  # Very small fit to run super fast
  data("Male_Gammarus_Single")
  modelData_MGS <- modelData(Male_Gammarus_Single, time_accumulation = 4)
  fit_MGS <- rmMessWarn(
      fitTK(modelData_MGS, iter = 10, chains = 2, refresh = 0)
  )
  data("Male_Gammarus_seanine_growth")
  modelData_MGSG <- modelData(Male_Gammarus_seanine_growth, time_accumulation = 1.417)
  fit_MGSG <- rmMessWarn(
      fitTK(modelData_MGSG, iter = 10, chains=2, refresh = 0)
  )
  
  expect_no_error(waic_MGS <- rmMessWarn(waic(fit_MGS)))
  expect_no_error(waic_MGSG <- rmMessWarn(waic(fit_MGSG)))
  
  expect_true(all(class(waic_MGS) == "numeric"))
  expect_true(all(class(waic_MGSG) == "numeric"))
  
})
