% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_taxonomy.R
\name{rba_uniprot_taxonomy_relationship}
\alias{rba_uniprot_taxonomy_relationship}
\title{Get Shortest Path Between Two Taxonomy Nodes}
\usage{
rba_uniprot_taxonomy_relationship(from, to, ...)
}
\arguments{
\item{from}{\href{https://www.uniprot.org/help/taxonomic_identifier}{NCBI
taxonomic identifier} of your initial node.}

\item{to}{\href{https://www.uniprot.org/help/taxonomic_identifier}{NCBI
taxonomic identifier} of your final node.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
a nested list containing the node which are in the shortest path
  between your supplied nodes.
}
\description{
Use this function to retrieve the shortest path between two nodes
in the taxonomy tree of
\href{https://www.uniprot.org/help/taxonomy}{UniProt Taxonomy database}.
}
\section{Corresponding API Resources}{

 "GET https://ebi.ac.uk/proteins/api/relationship"
}

\examples{
\donttest{
rba_uniprot_taxonomy_relationship(from = 9606, to = 10090)
}

}
\references{
\itemize{
  \item The UniProt Consortium , UniProt: the Universal Protein
  Knowledgebase in 2025, Nucleic Acids Research, 2024;, gkae1010,
  https://doi.org/10.1093/nar/gkae1010
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  \item \href{https://www.uniprot.org/help/publications}{Citations note
  on UniProt website}
  }
}
\seealso{
Other "UniProt - Taxonomy": 
\code{\link{rba_uniprot_taxonomy}()},
\code{\link{rba_uniprot_taxonomy_lca}()},
\code{\link{rba_uniprot_taxonomy_lineage}()},
\code{\link{rba_uniprot_taxonomy_name}()},
\code{\link{rba_uniprot_taxonomy_path}()}
}
\concept{"UniProt - Taxonomy"}
