% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BlockchainRpcs.R
\name{getblockheader}
\alias{getblockheader}
\title{RPC-JSON API: getblockheader}
\usage{
getblockheader(con, hash, verbose = TRUE)
}
\arguments{
\item{con}{object of class \code{CONRPC}.}

\item{hash}{\code{character} the block hash.}

\item{verbose}{\code{logical} \code{TRUE} for a json object,
\code{FALSE} for the hex encoded data.}
}
\value{
A S4-object of class \code{ANSRPC}.
}
\description{
Returns the block header for a given hash string.
}
\section{Details}{

If verbose is false, returns a string that is serialized,
hex-encoded data for blockheader 'hash'. If verbose is true,
returns an Object with information about blockheader <hash>.
}

\references{
\url{https://bitcoin.org/en/developer-reference#getblockheader},
\url{https://bitcoin.org/en/developer-reference#remote-procedure-calls-rpcs}
}
\seealso{
Other Blockchain RPCs: \code{\link{decodescript}},
  \code{\link{getbestblockhash}},
  \code{\link{getblockchaininfo}},
  \code{\link{getblockcount}}, \code{\link{getblockhash}},
  \code{\link{getblock}}, \code{\link{getchaintips}},
  \code{\link{getchaintxstats}},
  \code{\link{getdifficulty}},
  \code{\link{getmempoolancestors}},
  \code{\link{getmempooldescendants}},
  \code{\link{getmempoolentry}},
  \code{\link{getmempoolinfo}},
  \code{\link{getrawmempool}}, \code{\link{gettxoutproof}},
  \code{\link{gettxoutsetinfo}}, \code{\link{gettxout}},
  \code{\link{preciousblock}},
  \code{\link{pruneblockchain}}, \code{\link{verifychain}},
  \code{\link{verifytxoutproof}}
}
\author{
Bernhard Pfaff
}
\concept{Blockchain RPCs}
