% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sky_grid_centers.R
\name{sky_grid_centers}
\alias{sky_grid_centers}
\title{Map sky-grid centers to raster coordinates}
\usage{
sky_grid_centers(z, a, angle_width)
}
\arguments{
\item{z}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=zenith_image]{zenith_image()}}.}

\item{a}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=azimuth_image]{azimuth_image()}}.}

\item{angle_width}{numeric vector of length one. Angle in deg that must
divide both 0–360 and 0–90 into an integer number of segments. Retrieve a
set of valid values by running
\code{lapply(c(45, 30, 18, 10), function(a) vapply(0:6, function(x) a/2^x, 1))}.}
}
\value{
\code{data.frame} with integer columns \code{row} and \code{col}, one per grid cell.
}
\description{
Return image row and column indices for the center point of each
cell in a sky grid composed of circular trapezoids of equal angular
resolution defined by \code{angle_width}.
}
\examples{
z <- zenith_image(100, lens())
a <- azimuth_image(z)
sky_grid_centers(z, a, 45)
}
\seealso{
\code{\link[=sky_grid_segmentation]{sky_grid_segmentation()}}
}
