% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ewowin}
\alias{ewowin}
\title{Polygonal window of England and Wales}
\format{
An \code{owin} class object.
}
\source{
South,A.2011.rworldmap: A New R package for Mapping Global Data. The R Journal Vol. 3/1 : 35-43.
}
\usage{
ewowin
}
\description{
An \code{\link[spatstat.geom]{owin}} class polygonal window of England and Wales.
}
\examples{
\dontrun{
data(ewowin)
# Obtained from rworldmap:
library(maptools)
library(rgeos)
library(rworldmap)
bng <- CRS("+init=epsg:27700")
sbrit <- getMap(resolution="high")
sbrit <- spTransform(sbrit[sbrit$GEOUNIT =="United Kingdom",], bng)
tmp <- SpatialPolygons(list(Polygons(list(Polygon(cbind(c(130000,130000,310000,
425000,700000,700000,130000), c(0,300000,560000,598000,300000,0,0)))), 
"1")), 1:1, proj4string=bng)
sbrit <- gIntersection(sbrit,tmp) 
ewowin <- as.owin(sbrit)
}
}
\keyword{datasets}
