% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_varying-function.R
\name{time_varying}
\alias{time_varying}
\title{Generate time-varying data}
\usage{
time_varying(func, data, T_max)
}
\arguments{
\item{func}{Functions, an object class generated by
\code{\link{function_from_edge}} or \code{\link{function_from_user}}
functions. All vertices must be defined for their functions. The causal
structure needs to be a directed cyclic graph (DCG), which means loops are
allowed. Use \code{\link{edge_from_function}} to identify edges given a list
of functions, then draw a causal diagram using the edges data frame (see
vignettes). All arguments within any function must be defined by their
respective functions, except the argument 'n'. The output lengths of vertex
functions must match the input length.}

\item{data}{Data, a data frame generated by \code{\link{data_from_function}}
which contains causally-simulated data at t=0. Column names of 'i', 't', and
't_max' are not allowed, which respectively refer to instance, time, and
maximum time.}

\item{T_max}{Maximum time for every instance, a numeric vector of length
equal to the number of rows in 'data' and must be non-negative and
non-decimal.}
}
\value{
A data frame which include the simulated data for each vertex as a
column for each time up to maximum time for every instance.
}
\description{
Generate time-varying data
}
\examples{

data(functions)
simulated_data <- data_from_function(functions, n = 100)

function_B <- function(B){
  B + 1
}

functions <- define(functions, which = "B", what = function_B)
T_max <- rpois(nrow(simulated_data), lambda = 25)

time_varying(functions, data = simulated_data, T_max = T_max)
}
\keyword{time-varying-data-generation}
