/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Real2;

public class Int2
implements EuclidConstants {
    int x;
    int y;

    public Int2() {
        this.x = 0;
        this.y = 0;
    }

    public Int2(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Int2(Int2 r) {
        this.x = r.x;
        this.y = r.y;
    }

    public static Int2 getInt2(Real2 xy2) {
        return xy2 == null ? null : new Int2((int)xy2.x, (int)xy2.y);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Int2)) {
            return false;
        }
        Int2 i2 = (Int2)obj;
        return this.x == i2.x && this.y == i2.y;
    }

    public int hashCode() {
        return 13 * this.x + 37 * this.y;
    }

    public void swap() {
        int t = this.x;
        this.x = this.y;
        this.y = t;
    }

    public void sortAscending() {
        if (this.x > this.y) {
            this.swap();
        }
    }

    public void sortDescending() {
        if (this.x < this.y) {
            this.swap();
        }
    }

    public void clear() {
        this.y = 0;
        this.x = 0;
    }

    public void setX(int xx) {
        this.x = xx;
    }

    public void setY(int yy) {
        this.y = yy;
    }

    public boolean isEqualTo(Int2 r) {
        return this.x == r.x && this.y == r.y;
    }

    public Int2 plus(Int2 r2) {
        return new Int2(this.x + r2.x, this.y + r2.y);
    }

    public Int2 subtract(Int2 r2) {
        return new Int2(this.x - r2.x, this.y - r2.y);
    }

    public void negative() {
        this.x = -this.x;
        this.y = -this.y;
    }

    public Int2 multiplyBy(int f) {
        return new Int2(this.x * f, this.y * f);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int elementAt(int elem) throws EuclidRuntimeException {
        if (elem == 0) {
            return this.x;
        }
        if (elem == 1) {
            return this.y;
        }
        throw new EuclidRuntimeException("bad index " + elem);
    }

    public Int2 getMidPoint(Int2 p) {
        return new Int2((this.x + p.x) / 2, (this.y + p.y) / 2);
    }

    public int dotProduct(Int2 r) {
        return this.x * r.x + this.y * r.y;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public double getEuclideanDistance(Int2 int2) {
        return new Real2(this).getDistance(new Real2(int2));
    }

    public double getManhattanDistance(Int2 int2) {
        return Math.abs(this.x - int2.x) + Math.abs(this.y - int2.y);
    }

    public Int2 incrementX() {
        ++this.x;
        return this;
    }

    public Int2 decrementX() {
        --this.x;
        return this;
    }

    public Int2 incrementY() {
        ++this.y;
        return this;
    }

    public Int2 decrementY() {
        --this.y;
        return this;
    }

    public static boolean isEqual(Int2 xy0, Int2 xy1) {
        return xy0 != null && xy1 != null && xy0.isEqualTo(xy1);
    }
}

