% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection.R
\name{chroma_docker_run}
\alias{chroma_docker_run}
\title{Start ChromaDB Docker Container}
\usage{
chroma_docker_run(
  port = 8000,
  volume_host_dir = "./chroma",
  is_persistent = TRUE,
  anonymized_telemetry = FALSE,
  version = "0.6.3",
  container_name = "chromadb"
)
}
\arguments{
\item{port}{The port for the ChromaDB container.}

\item{volume_host_dir}{A string specifying the host directory to persist data.}

\item{is_persistent}{Logical; whether to enable persistence. Defaults to \code{TRUE}.}

\item{anonymized_telemetry}{Logical; whether to enable anonymous telemetry. Defaults to \code{FALSE}.}

\item{version}{A string specifying the version of the ChromDB Docker image. Default is \code{"0.6.3"}.}

\item{container_name}{A string specifying the name for the Docker container. Default is \code{"chromadb"}.}
}
\value{
Invisibly returns \code{TRUE} if the container is already running or started successfully.
}
\description{
This function uses Docker to start a ChromaDB server container in the background.
}
