% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{code}
\alias{code}
\title{Encode a label to a value with other metadata}
\usage{
code(
  label,
  value,
  description = label,
  links_from = label,
  missing = FALSE,
  ...
)
}
\arguments{
\item{label}{A short label for a value in a vector}

\item{value}{The raw value found in the respective vector}

\item{description}{A longer-form label for the value, if extra context for
that label is needed}

\item{links_from}{A reference to another `code` in another `coding` object
for recoding purposes.}

\item{missing}{Whether this `code` represents a missing response}

\item{...}{Any extra metadata}
}
\value{
A `code` object that contains the key-value map of label to value
}
\description{
The most fundamental components of a `code` object are the `label` and
`value` elements. A `code` object is essentially a key-value tuple that has
some extra metadata.
}
\examples{
code("Yes", 1)
code("No", 0)
code(
  "No response", -88,
  description = "Participant ignored question when prompted",
  missing = TRUE
)
code("Missing", NA, links_from = c("Refused", "Absent"))
}
