% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coding.R
\name{coding}
\alias{coding}
\alias{empty_coding}
\title{Catalog the categorical data representation in a vector}
\usage{
coding(..., .label = NULL)

empty_coding()
}
\arguments{
\item{...}{A collection of `code` objects}

\item{.label}{A label for this coding, available for interoperability}
}
\value{
A `coding` object that contains each `code` input
}
\description{
A `coding` object holds a list of `code`s that map vector values to human
readable labels. An abstraction of factors, this data structure is designed
to be portable and not directly attached to the underlying data. Moreover,
`coding` objects can be "linked" for recoding and data lineage purposes. An
"empty coding" is used to represent data that has no categorical
interpretation.
}
\examples{
coding(code("Yes", 1), code("No", 0), code("Not applicable", NA))
empty_coding()
}
