% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/troll.R
\name{troll}
\alias{troll}
\title{Run a \code{TROLL} simulation}
\usage{
troll(
  name = NULL,
  path = NULL,
  global,
  species,
  climate,
  daily,
  lidar = NULL,
  forest = NULL,
  load = TRUE,
  verbose = TRUE,
  overwrite = TRUE,
  thin = NULL
)
}
\arguments{
\item{name}{char. Model name (if NULL the timestamp will be used).}

\item{path}{char. Path to save the simulation outputs, the default is null
corresponding to a simulation in memory without saved intermediary files
(based on temporary files from \link{option.rcontroll}).}

\item{global}{df. Global parameters (e.g. \link{TROLLv3_input} or using
\code{\link[=generate_parameters]{generate_parameters()}}).}

\item{species}{df. Species parameters (e.g. \link{TROLLv3_species}).}

\item{climate}{df. Climate parameters (e.g. \link{TROLLv3_climatedaytime12}).}

\item{daily}{df. Daily variation parameters (e.g. \link{TROLLv3_daytimevar}).}

\item{lidar}{df. Lidar simulation parameters (e.g. using \code{\link[=generate_lidar]{generate_lidar()}}),
if null not computed (default NULL).}

\item{forest}{df. TROLL with forest input, if null starts from an empty grid
(default NULL) (e.g. using \link{TROLLv3_output} with \code{\link[=get_forest]{get_forest()}}).}

\item{load}{bool. TROLL outputs are loaded in R memory, if not only the path
and name of the simulations is kept in the resulting \code{\link[=trollsim]{trollsim()}} object
but the content can be accessed later using the \code{\link[=load_sim]{load_sim()}} method.}

\item{verbose}{bool. Show TROLL log in the console.}

\item{overwrite}{bool. Overwrite previous outputs folder and files.}

\item{thin}{int. Vector of integers corresponding to the iterations to be
kept to reduce output size, default is NULL and corresponds to no thinning.}
}
\value{
A \code{\link[=trollsim]{trollsim()}} object.
}
\description{
\code{troll()} run a \code{TROLL} simulation. The minimal set of input files required
for a \code{TROLL} run include (i) climate data for the focal location (\code{climate}
and \code{daily}), (ii) functional traits for the list of species at the focal
location (\code{species}), and (iii) global parameters (\code{global}), i.e. parameters
that do not depend on species identity.
}
\examples{
\donttest{
data("TROLLv3_species")
data("TROLLv3_climatedaytime12")
data("TROLLv3_daytimevar")
troll(
  name = "test",
  global = generate_parameters(
    cols = 100, rows = 100,
    iterperyear = 12, nbiter = 12 * 1
  ),
  species = TROLLv3_species,
  climate = TROLLv3_climatedaytime12,
  daily = TROLLv3_daytimevar
)
}

}
\seealso{
\code{\link[=stack]{stack()}}
}
