% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Node.R
\docType{class}
\name{Node}
\alias{Node}
\title{A node in a graph}
\description{
An R6 class representing a node in a graph.
}
\details{
A base class to represent a single node in a graph.
}
\author{
Andrew Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Node-new}{\code{Node$new()}}
\item \href{#method-Node-label}{\code{Node$label()}}
\item \href{#method-Node-modvars}{\code{Node$modvars()}}
\item \href{#method-Node-type}{\code{Node$type()}}
\item \href{#method-Node-clone}{\code{Node$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Node-new"></a>}}
\if{latex}{\out{\hypertarget{method-Node-new}{}}}
\subsection{Method \code{new()}}{
Create new \code{Node} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Node$new(label = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{label}}{An optional label for the node.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Node} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Node-label"></a>}}
\if{latex}{\out{\hypertarget{method-Node-label}{}}}
\subsection{Method \code{label()}}{
Return the label of the node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Node$label()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Label as a character string.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Node-modvars"></a>}}
\if{latex}{\out{\hypertarget{method-Node-modvars}{}}}
\subsection{Method \code{modvars()}}{
Find all the model variables of type \code{ModVar} that have
been specified as values associated with this \code{Node}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Node$modvars()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An empty list for the base class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Node-type"></a>}}
\if{latex}{\out{\hypertarget{method-Node-type}{}}}
\subsection{Method \code{type()}}{
node type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Node$type()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{Node} class, as character string.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Node-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Node-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Node$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
