% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_apra.R
\name{read_apra_local}
\alias{read_apra_local}
\title{Read APRA Publication Statistics Locally}
\usage{
read_apra_local(file_path, stat_pub, cur_hist = "current")
}
\arguments{
\item{file_path}{path to the local file from which the statistical
publication data will be imported.}

\item{stat_pub}{character vector detailing a statistical publication to be
imported. Must match a valid value in the \code{apra_stat_pubs_acronym} variable
of the \link{apra_stat_pubs} dataset.}

\item{cur_hist}{character vector detailing whether to import a current
or historic statistical publication. Must match a
valid value in the \code{cur_hist} variable of the \link{apra_stat_pubs}
dataset.}
}
\value{
A tibble containing the statistical publication data.
}
\description{
Import from a local file a specific statistical publication produced by APRA.

Please consult the \link{apra_stat_pubs} dataset to see which of APRA's
statistical publications are available in \code{readapra}.
}
\examples{
\donttest{
# Download the current MADIS data and get the file path:
current_madis_file_path <-
  download_apra(stat_pub = "madis", cur_hist = "current")

# Import the current MADIS data:
current_madis_data <-
  read_apra_local(
    stat_pub = "madis",
    cur_hist = "current",
    file_path = current_madis_file_path
  )

# Examine the current MADIS data:
print(current_madis_data)
}

}
