% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-any-bitmap.R
\name{read.bitmap}
\alias{read.bitmap}
\title{Read in a bitmap image in JPEG, PNG, BMP or TIFF format}
\usage{
read.bitmap(f, channel, IdentifyByExtension = FALSE, ...)
}
\arguments{
\item{f}{Path to image file}

\item{channel}{Integer identifying channel to return for an RGB image}

\item{IdentifyByExtension}{Identify by file extension only (Default FALSE)}

\item{...}{Additional parameters passed to underlying image readers}
}
\value{
Objects returned by \code{\link[jpeg]{readJPEG}},
  \code{\link[png]{readPNG}}, \code{\link[bmp]{read.bmp}}, or
  \code{\link[tiff]{readTIFF}}. See their documentation for details.
}
\description{
By default uses magic bytes at the start of the file to identify the image
type (rather than the file extension). Currently uses readers in bmp, jpeg,
png, and tiff packages.
}
\examples{
img1=read.bitmap(system.file("img", "Rlogo.jpg", package="jpeg"))
str(img1)
img2 <- read.bitmap(system.file("img", "Rlogo.png", package="png"))
# nb the PNG image has an alpha channel
str(img2)
}
\seealso{
\code{\link{image_type}}, \code{\link[jpeg]{readJPEG}},
  \code{\link[png]{readPNG}}, \code{\link[bmp]{read.bmp}},
  \code{\link[tiff]{readTIFF}}
}
