% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read2list.R
\name{read2list}
\alias{read2list}
\title{Read various input file formats into a list of data frames}
\usage{
read2list(
  dat,
  nsheets = 1,
  sheet = NULL,
  keep.tibble = FALSE,
  skip = 0,
  sep = NULL,
  lines = FALSE,
  dec = NULL,
  ...,
  verbose = TRUE,
  x.verbose = FALSE
)
}
\arguments{
\item{dat}{\code{character}. File path.}

\item{nsheets}{\code{integer}. Number of sheets to be read if file is of type ".xls" or ".xlsx". All sheets starting from 1 up to the
given number in the respective data file will be read. If more than one file is read this must be be an integer vector with the
numbers of sheets in exactly the same order as the files.}

\item{sheet}{\code{integer} or \code{list}. Sheet(s) to be read if file is of type ".xls" or ".xlsx". The sheets defined by the given integer in the
respective data file will be read. If more than one file is read this must be be a list with the sheet number(s) in exactly
the same order as the files. If there are many files and only one sheet vector the same sheet(s) wiöl be read from
all files.}

\item{keep.tibble}{\code{logical}. Should the data from Excel files read with \code{readxl::read_excel} be coerce to 
\code{data.frames} or kept in the original \code{tibble} format? Defaults to FALSE, i.e., a \code{data.frame}
is returned.}

\item{skip}{\code{integer}. Number of lines to skip from the top of the file.}

\item{sep}{\code{character}. Field delimiter passed to 'read.delim' when reading text files.}

\item{lines}{\code{lines}. Should the file be read line by line into a character vector by readLines()?}

\item{dec}{\code{character}. The decimal separator for numbers.}

\item{...}{Additional arguments passed to functions.}

\item{verbose}{\code{logical}. Should verbose output be printed?}

\item{x.verbose}{\code{logical}. Should extended verbose output be printed?}
}
\description{
\command{read2list} is meant to act as a universal reading function as it attempts to read
a number of different file formats into a list of data frames.
}
\seealso{
\code{\link[utils]{read.delim}}

\code{\link[readxl]{read_excel}}

\code{\link[readmoRe]{read.to.list}}
}
\keyword{utilities}
