% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_ode_function.R
\name{stan_ode_function}
\alias{stan_ode_function}
\title{Create Stan ODE function}
\usage{
stan_ode_function(
  filepath,
  func_name,
  pars = NULL,
  const_list = NULL,
  extra_funs = NULL,
  XMILE_structure
)
}
\arguments{
\item{filepath}{A string that indicates a path to a file with extension .stmx
or .xmile. Vensim files (.mdl) are not xmile files. They must be exported
from Vensim with extension .xmile}

\item{func_name}{A string for naming the ODE function}

\item{pars}{A character vector that indicates which constants will be
considered as parameters in the ODE function}

\item{const_list}{A list in which each element's name is the name of the
constant to override and the element's value correspond to the new value.}

\item{extra_funs}{A vector of strings. Each string corresponds to a
user-defined function.}

\item{XMILE_structure}{A list.}
}
\value{
A string with the code containing a function with the model's
  equations in the format required by cmdstan 2.24+.
}
\description{
Create Stan ODE function
}
\examples{
path <- system.file("models", "SIR.stmx", package = "readsdr")
stan_ode_function(path, "my_model")
}
