% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acoustic_backscatter_processing.R
\name{acoustic_backscatter_processing}
\alias{acoustic_backscatter_processing}
\title{Process acoustic backscatter from hADCP}
\usage{
acoustic_backscatter_processing(
  Site,
  ADCP,
  Height,
  Sonde,
  Echo_Intensity_Beam_1,
  Echo_Intensity_Beam_2,
  Instrument_Noise_Level = NULL,
  Include_Rayleigh = FALSE,
  Include_near_field_correction = TRUE
)
}
\arguments{
\item{Site}{Data frame with site, local vertical datum, and ADCP elevation information
\describe{
\item{Site_name}{Site name (string)}
\item{Site_number}{Unique site code (string)}
\item{ADCP_elevation_above_bed_m}{Elevation of the ADCP above the bed (m)}
\item{ADCP_elevation_above_gauge_datum_m}{Elevation of the ADCP above local gauge datum (m)}
\item{Distance_of_gauge_datum_below_thalweg_m}{Distance from local gauge datum to lower point in cross-section (m)}
\item{Start_date_and_time}{Installation date of ADCP (time, POSIXct)}
\item{End_date_and_time}{Date if/when ADCP is moved vertically (time, POSIXct)}
\item{Comment}{User comment (string)}
}}

\item{ADCP}{Data frame with various readings from ADCP
\describe{
\item{Site_number}{Unique site code (string)}
\item{time}{Date and time (time, POSIXct)}
\item{Ensemble}{Measurment ensemble number (integer)}
\item{Accoustic_Frequency_kHz}{Acoustic frequency of ADCP (kHz)}
\item{Transducer_radius_m}{Radius of ADCP transducer (m)}
\item{Beam_angle_degrees}{Angle of beam relative to normal (degrees)}
\item{Beam_aspect_ratio}{Ratio of beam radius to beam length (-)}
\item{Range_to_bed_of_acoustic_beams_m}{Normal range to bed, optional (m)}
\item{Range_to_water_surface_of_acoustic_beams_m}{Normal range to water surface, optional (m)}
\item{Number_of_Cells}{Number of measurement cells along beam (integer)}
\item{Bin_Size_m}{Cell width measured normal to ADCP (m)}
\item{Blanking_distance_m}{Blanking distance measured normal to ADCP (m)}
\item{Instrument_serial_number}{Serial number of ADCP instrument (string)}
\item{CPU_serial_number}{Serial number of ADCP CPU (string)}
\item{Ambient_Noise_Level_Beam_1_Counts}{Ambient noise level for beam 1, optional (counts)}
\item{Ambient_Noise_Level_Beam_2_Counts}{Ambient noise level for beam 2, optional (counts)}
\item{Distance_to_Bin_1_mid_point_m}{Reported distance normal to ADCP to midpoint of bin/cell (m)}
\item{Distance_to_surface_m}{Reported depth of ADCP from vertical beam, optional (m)}
\item{Speed_of_sound_m_per_s}{Speed of sound used by ADCP in the field (m/s)}
\item{Temperature_degC}{Temperature recorded by ADCP (degrees C)}
\item{Pressure_dbar}{Pressure recorded by ADCP (dBar)}
\item{Salinity_PSU}{Salinity in PSU recorded or assumed in ADCP data file, optional (PSU)}
\item{Distance_to_surface_m}{Distance to water surface reported by vertical beam of ADCP (m)}
\item{Power_supply_voltage}{Power to ADCP (V)}
}}

\item{Height}{Data frame with timeseries of river height
\describe{
\item{time}{Date and time (time, POSIXct)}
\item{Height_m}{Water surface elevation above gauge datum (m)}
\item{Site_number}{Unique site code (string)}
}}

\item{Sonde}{Data frame with timeseries of conductivity, temperature, and depth from sonde
\describe{
\item{time}{Date and time (time, POSIXct)}
\item{Water_Temperature_degC}{Temperature (degrees C)}
\item{Conductivity_uS_per_cm}{Conductivity (microS/cm)}
\item{Pressure_dbar}{Pressure (dbar)}
\item{Site_number}{Unique site code (string)}
}}

\item{Echo_Intensity_Beam_1}{Data frame of acoustic backscatter measurements from beam 2
\describe{
\item{Site_number}{Unique site code (string)}
\item{time}{Date and time (time, POSIXct)}
\item{Echo_Intensity_Counts_cell_n}{Acoustic backscatter in nth cell (counts)}
}}

\item{Echo_Intensity_Beam_2}{Data frame of acoustic backscatter measurements from beam 2
\describe{
\item{Site_number}{Unique site code (string)}
\item{time}{Date and time (time, POSIXct)}
\item{Echo_Intensity_Counts_cell_n}{Acoustic backscatter in nth cell (counts)}
}}

\item{Instrument_Noise_Level}{Estimate of noise level, recommended if ambient noise level is not recorded (counts)}

\item{Include_Rayleigh}{Logical to include data within Rayleigh Distance for processing of acoustic backsactter}

\item{Include_near_field_correction}{Logical to include near-field correction of Downing et al (1995)}
}
\value{
List with processed data, all variable names and units are written-out in list items, see Livsey (in review) for details of each variable
}
\description{
Processes acoustic backscatter from horizontally profiling ADCP (hADCP). Returns attenuation of sound due to water and suspended-sediment. Applies all corrections to acoustic backscatter detailed in the guideline.
}
\examples{
InputData <- realTimeloads::ExampleData
Site <- InputData$Site
ADCP <- InputData$ADCP
Height <- InputData$Height
Sonde <- InputData$Sonde
EIa <- InputData$Echo_Intensity
# example code assumes backscatter is equal across beams
EIb <- InputData$Echo_Intensity
Output <- acoustic_backscatter_processing(Site,ADCP,Height,Sonde,EIa,EIb)
}
\references{
Livsey, D.N. (in review). National Industry Guidelines for hydrometric monitoring–Part 12: Application of acoustic Doppler velocity meters to measure suspended-sediment load. Bureau of Meteorology. Melbourne, Australia.
}
\author{
Daniel Livsey (2023) ORCID: 0000-0002-2028-6128
}
