% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/butterworth_tidal_filter.R
\name{butterworth_tidal_filter}
\alias{butterworth_tidal_filter}
\title{Return non-tidal signal in data after Rulh and Simpson (2005)}
\usage{
butterworth_tidal_filter(time, x)
}
\arguments{
\item{time}{time for x (time, POSIXct)}

\item{x}{any quantity, for example discharge (double)}
}
\value{
non-tidal signal in x with data affected by filter ringing removed
}
\description{
Applies a Butterworth filter with a 30-hour stop period and a 40-hour pass period
}
\examples{
time <- realTimeloads::ExampleData$Height$time
x <- realTimeloads::ExampleData$Height$Height_m
xf <- butterworth_tidal_filter(time,x)
}
\references{
Ruhl, C. A., & Simpson, M. R. (2005). Computation of discharge using the index-velocity method in tidally affected areas (Vol. 2005). Denver: US Department of the Interior, US Geological Survey. https://pubs.usgs.gov/sir/2005/5004/sir20055004.pdf
}
\author{
Daniel Livsey (2023) ORCID: 0000-0002-2028-6128
}
