% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/near_field_correction.R
\name{near_field_correction}
\alias{near_field_correction}
\title{Near-field correction of Downing et al (1995)}
\usage{
near_field_correction(freq, c, r, at)
}
\arguments{
\item{freq}{Frequency of sound (Hz)}

\item{c}{Speed of sound in water (m/s)}

\item{r}{range to cell center measured along-beam (m)}

\item{at}{Radius of ADCP transducer (m)}
}
\value{
Near-field correction (dimensionless)
}
\description{
Computes dimensionless near-field correction
}
\section{Warning}{

See various references cautioning use of near-field correction (e.g.,  https://doi.org/10.1002/2016WR019695)
}

\examples{
InputData <- realTimeloads::ExampleData
Sonde<- InputData$Sonde
freq <- InputData$ADCP$Accoustic_Frequency_kHz[1]*1000
S <- ctd2sal(Sonde$Conductivity_uS_per_cm,Sonde$Water_Temperature_degC,Sonde$Pressure_dbar)
c <- speed_of_sound(S,Sonde$Water_Temperature_degC,Sonde$Pressure_dbar)
at <- InputData$ADCP$Transducer_radius_m
r <- seq(0.1,10,0.1)
psi <- near_field_correction(freq,c[1],r,at[1])
}
\references{
Downing, A., Thorne, P. D., & Vincent, C. E. (1995). Backscattering from a suspension in the near field of a piston transducer. The Journal of the Acoustical Society of America, 97(3), 1614-1620.
}
\author{
Daniel Livsey (2023) ORCID: 0000-0002-2028-6128
}
