#' Distribuția pe zile curentă trebuie să păstreze alocarea tuplajelor
#'
#' Tuplajele (dacă există) vizează lecțiile care au fost fixate în prealabi,
#' pe anumite zile; în principiu, trebuie evitată modificarea acestor alocări.
#
#' @param DZ Distribuția lecțiilor pe zile (curentă)
#' @param TP Setul tuplajelor (repartizate din start pe zile)
#' @return TRUE dacă repartiția tuplajelor n-a fost modificată, sau primul
#'     tuplaj la care distribuția inițială nu coincide cu cea curentă
#' @export

keep_toupled <- function(DZ, TP) {
    for(i in 1:nrow(TP)) {
        Prof <- strsplit(TP[i, 1], " ")[[1]]
        Cls <- strsplit(TP[i, 2], " ")[[1]]
        ZT <- strsplit(TP[i, 3], " ")[[1]] %>% sort()
        LL <- pmap(list(Prof, Cls), function(P, K) 
           DZ %>% filter(.data$prof==P & .data$cls==K) %>% pull(.data$zl))
        ZL <- Reduce(intersect, LL) %>% sort()
        if(! identical(ZL, ZT))
            return(list(TP[i, ], ZL))
    }
    return(TRUE)
}

