#' Distribuția pe zile a numărului de lecții ale celor angajați în tuplaje
#'
#' Pentru un profesor implicat în tuplaje, putem să-i omogenizăm distribuția
#' lecțiilor mutând într-o altă zi una sau alta dintre acele clase ale sale,
#' care nu sunt indicate în tuplajele din care face parte acel profesor.
#'
#' @param DZ Distribuția curentă a tuturor lecțiilor
#' @param TP Setul de tuplaje
#' @return Matricea cu distribuțiile membrilor tuplajelor (incluzând
#'     și lecțiile acestora din afara tuplajelor)
#' @export
#'
toupled_dis <- function(DZ, TP) {
    Lp <- lapply(TP$prof, function(P) strsplit(P, " ")[[1]])
    Tp <- Lp %>% unlist() %>% as.vector() %>% unique()
    D <- DZ %>% filter(.data$prof %in% Tp) %>% droplevels()
    table(D[c('prof', 'zl')])
}

