% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recmap.R
\name{.get_7triangles}
\alias{.get_7triangles}
\title{construct polygon mesh displayed in Figure 4a in}
\usage{
.get_7triangles(A = 1)
}
\arguments{
\item{A}{defines the area of a region in the center}
}
\value{
a \link[sp]{SpatialPolygons} object
}
\description{
construct polygon mesh displayed in Figure 4a in
}
\examples{
triangle.map <- recmap:::.get_7triangles()
z <- c(rep(4, 4), rep(1, 3))
cols <- c(rep('white', 4), rep('grey',3))

op <- par(mfrow=c(1,2), mar=c(0, 0, 0, 0))
plot(triangle.map, col=cols)

\dontrun{
 # requires libfft.so installed in linux 
if (require(getcartr) & require(Rcartogram)){
  cartogram <- quick.carto(triangle.map, z, res=64)
  plot(cartogram, col=cols)
}
}
}
\references{
\doi{10.1109/TVCG.2004.1260761}
}
