% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorClusters.R
\name{colorClustersHist}
\alias{colorClustersHist}
\title{Cluster pixel colors using histogram binning}
\usage{
colorClustersHist(
  pixel_matrix,
  bins = 3,
  color_space = c("Lab", "sRGB", "Luv", "HSV"),
  ref_white = "D65",
  bin_avg = TRUE
)
}
\arguments{
\item{pixel_matrix}{2D matrix of pixels to classify (rows = pixels, columns =
channels).}

\item{bins}{Number of bins for each channel OR a vector of length 3 with bins
for each channel. \code{bins = 3} will result in 3^3 = 27 bins; \code{bins = c(2, 2, 3)}
will result in 2\emph{2}3 = 12 bins (2 red, 2 green, 3 blue if you're in RGB
color space), etc.}

\item{color_space}{Color space in which to cluster colors, passed to
\code{[grDevices]{convertColor}}. One of "sRGB", "Lab", or "Luv".
Default is "Lab", a perceptually uniform (for humans) color space.}

\item{ref_white}{Reference white for converting to different color spaces.
D65 (the default) corresponds to standard daylight.}

\item{bin_avg}{Logical. Return the color centers as the average of the pixels
assigned to the bin (the default), or the geometric center of the bin?}
}
\value{
A list with the following elements:
\enumerate{
\item \code{pixel_assignments}: A vector of color center assignments for
each pixel.
\item \code{centers}: A matrix of color centers.
\item \code{sizes}: The number of pixels assigned to each cluster.
}
}
\description{
Clusters pixel colors by dividing color space up into specified bins,
then taking the average color of all the pixels within that bin.
}
\details{
Called by \code{\link[=colorClusters]{colorClusters()}}. See that documentation for
examples.
}
