% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imDist.R
\name{imHeatmap}
\alias{imHeatmap}
\title{Plot a heatmap of a matrix of color distances}
\usage{
imHeatmap(
  mat,
  palette = "default",
  main = "",
  range = NULL,
  legend = TRUE,
  ...
)
}
\arguments{
\item{mat}{A color distance matrix, preferably output of
\code{\link[=imDist]{imDist()}}.}

\item{palette}{The color palette to be used. Default is blue to
red (\code{colorRamps::blue2red(100)}).}

\item{main}{Plot title.}

\item{range}{Range for heatmap values. Defaults to the range of values in the
matrix, but should be set to the same range for all images if comparing
heatmaps.}

\item{legend}{Logical. Add a continuous color legend?}

\item{...}{Parameters passed to \code{\link[graphics:image]{graphics::image()}}.}
}
\value{
Nothing; plots a heatmap of the color residuals.
}
\description{
Plots the output of \code{\link[=imDist]{imDist()}} as a heatmap.
}
\examples{
chongi <- system.file("extdata/chongi.png", package = "recolorize")
chongi <- png::readPNG(chongi)
chongi_k <- recolorize(chongi, "k", n = 5)

recolored_chongi <- constructImage(chongi_k$pixel_assignments,
                                   chongi_k$centers)
d <- imDist(chongi,
            recolored_chongi, plotting = FALSE)

# original flavor
imHeatmap(d)

# bit offputting
imHeatmap(d, palette = colorRamps::ygobb(100))

# just dreadful
imHeatmap(d, palette = colorRamps::primary.colors(100))
}
