% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refreshr.r
\name{properties}
\alias{properties}
\title{Analysing refreshr objects}
\usage{
properties(df, property = NULL, silent = FALSE)
}
\arguments{
\item{df}{Dataframe/table to be checked.}

\item{property}{One-element Character vector describing the property thatto
be queried. Either \code{"load"} for the load code (the code that refreshes
data from the data source),  \code{"prep"} for the data preparation code (of
any),  \code{"source"} for the data source (which \code{properties()} tries
to identify from the load code),  \code{"lastrefresh"} (the date/timestamp of the last refresh of the dataframe/table). If no property is selected (\code{property == NULL}, the default) then all properties are included in the output to the screen.}

\item{silent}{If silent the function will return (invisibly) the property
defined by \code{property} without making any outputs on the screen.
Default is \code{FALSE}.}
}
\value{
if \code{property == NULL}, i.e. all properties are queried, then  \code{NULL} is returned. Otherwise \code{properties()} returns the value of the selected property.
}
\description{
Checks if a dataframe/table is refreshable.
}
\examples{
\dontrun{

library(data.table)
library(dplyr)

# Load US unemployment rate from Bureau of Labor Statistics
data <- fread("https://download.bls.gov/pub/time.series/ln/ln.data.1.AllData", sep="\t")

# Make refreshable and specify code for data preparation (filter raw data for
# the overall US employment rate) with # being a placeholder for the downloaded
# raw data
data_refresh <- make_refreshable(data,
                     load_code = "data.table::fread(
                        \"https://download.bls.gov/pub/time.series/ln/ln.data.1.AllData\",
                        sep=\"\t\")",
                     prep_code = "filter(#, series_id==\"LNS14000000\")")
                     #'
# Save refreshable dataframe as RData file (e.g. to share dataset with coworkers or public)
save(data_refresh, file = "refresh.RData")

# Remove dataframe and reload it from file
rm(data_refresh)
load(file = "refresh.RData")

# Refresh the dataframe
data_refresh <- refresh(data_refresh)

# Show properties of refreshable dataframe
properties(data_refresh)

# Check if refreshable dataframe is up-to-date with the remote data source
uptodate(data_refresh)
}
}
