% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_RNA2protein.R
\name{refseq_RNA2protein}
\alias{refseq_RNA2protein}
\title{Get the protein accession from the transcript accession}
\usage{
refseq_RNA2protein(transcript)
}
\arguments{
\item{transcript}{A character string of the protein accession.}
}
\value{
A character vector containing the protein id encoded by the mRNA especified as \code{transcript}.
}
\description{
\code{refseq_RNA2protein()} Returns the protein accession from a single transcript accession.

Depending on the function, available accessions in \code{refseqR} include RefSeq models with the prefixes XM_ (mRNA), XR_ (non-coding RNA), and XP_ (protein), as well as subsequently curated RefSeq records with NM_, NR_, or NP_ accession prefixes.
}
\examples{
 \dontrun{
 # Get the protein id from a single transcript accession
 transcript <- "XM_004487701"
 refseq_RNA2protein(transcript)

 # Get the protein ids from a set of transcript accessions
 transcript = c("XM_004487701", "XM_004488493")
 sapply(transcript, function(x) refseq_RNA2protein(x), USE.NAMES = FALSE) }

}
\seealso{
\code{\link{refseq_protein2RNA}} to obtain the transcript ids that encode a set of proteins ids.
}
\author{
Jose V. Die
}
