% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rHMM_one_step.R
\name{rHMM_one_step}
\alias{rHMM_one_step}
\title{Single Iteration of EM Algorithm for Fitting Regularized Hidden Markov Model (rHMM)}
\usage{
rHMM_one_step(
  delta,
  Y_mat,
  A,
  B,
  X_cube,
  family,
  omega_cva = sqrt(sqrt(seq(0, 1, len = 5))),
  trace = 0
)
}
\arguments{
\item{delta}{a vector of length S specifying the initial probabilities.}

\item{Y_mat}{a matrix of observations of size N x T.}

\item{A}{a matrix of size S x S specifying the transition probabilities.}

\item{B}{a matrix of size S x (p + 1) specifying the GLM parameters of the emission probabilities.}

\item{X_cube}{a design array of size T x p x N.}

\item{family}{the family of the response.}

\item{omega_cva}{a vector of omega values for the modified cyclical coordinate descent algorithm used for cross-validation.}

\item{trace}{logical indicating if detailed output should be produced during the fitting process.}
}
\value{
A list object with the following slots:

\item{delta_hat}{the estimate of delta.}

\item{A_hat}{the estimate of A.}

\item{B_hat}{the estimate of B.}

\item{log_likelihood}{the log-likelihood of the model.}

\item{lambda}{lambda from CV.}

\item{omega}{omega from CV.}
}
\description{
Execute a single iteration of the Expectation-Maximization (EM) algorithm designed for fitting a regularized Hidden Markov Model (rHMM).
}
\examples{
\donttest{
# Example usage of the function
seed_num <- 1
p_noise <- 2
N <- 100
N_persub <- 50
parameters_setting <- list(
  init_vec = c(0.5, 0.5),
  trans_mat = matrix(c(0.7, 0.3, 0.2, 0.8), nrow = 2, byrow = TRUE),
  emis_mat = matrix(c(1, 0.5, 0.5, 2), nrow = 2, byrow = TRUE)
)
simulated_data <- simulate_HMM_data(seed_num, p_noise, N, N_persub, parameters_setting)

init_start = c(0.5, 0.5)
trans_start = matrix(c(0.5, 0.5, 0.5, 0.5), nrow = 2)
emis_start = matrix(rep(1, 8), nrow = 2)

rHMM_one_step <- rHMM_one_step(delta=as.matrix(init_start),
                               Y_mat=simulated_data$y_mat,
                               A=trans_start,
                               B=emis_start,
                               X_cube=simulated_data$X_array,
                               family="P",
                               omega_cva=sqrt(sqrt(seq(0, 1, len = 5))),
                               trace = 0)
}

}
