% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_description.R
\name{set_latest_deps_version}
\alias{set_latest_deps_version}
\title{Set latest versions for \verb{rjd3*} dependencies}
\usage{
set_latest_deps_version(path, verbose = TRUE)
}
\arguments{
\item{path}{[\link[base]{character}] Path to the package root directory.}

\item{verbose}{[\link[base]{logical}] Whether to print current and new
remote fields (default: \code{TRUE}).}
}
\value{
Invisibly updates the \code{DESCRIPTION} file in place.
}
\description{
Update the \code{DESCRIPTION} file of a package so that all dependencies
beginning with \code{"rjd3"} require the latest released version from GitHub.
}
\examples{
\donttest{
path_rjd3workspace <- file.path(tempdir(), "rjd3workspace")
file.copy(
    from = system.file("rjd3workspace", package = "releaser"),
    to = dirname(path_rjd3workspace),
    recursive = TRUE
)

set_latest_deps_version(path = path_rjd3workspace)
}

}
