% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLS_functions.R
\name{fitCLS}
\alias{fitCLS}
\title{CLS for time series}
\usage{
fitCLS(
  formula,
  data = NULL,
  lag.y = 1,
  lag.x = 1,
  debug = FALSE,
  model = FALSE,
  y = FALSE
)
}
\arguments{
\item{formula}{a model formula, as used by \code{stats::lm()}}

\item{data}{optional data environment to search for variables in \code{formula}.
As used by \code{lm()}}

\item{lag.y}{an integer indicating the lag (in time steps) between y and y.0}

\item{lag.x}{an integer indicating the lag (in time steps) between y and the
independent variables (except y.0).}

\item{debug}{logical debug mode}

\item{model}{logical, should the used model matrix be returned? As used by
\code{lm()}}

\item{y}{logical, should the used response variable be returned? As used by
\code{lm()}}
}
\value{
\code{fitCLS} returns a list object of class "remoteTS", which
inherits from  "lm". In addition to the default "lm" components, the output
contains these additional list elements:

\describe{
   \item{tstat}{the t-statistics for coefficients}
   \item{pval}{the p-values corresponding to t-tests of coefficients}
   \item{MSE}{the model mean squared error}
   \item{logLik}{the log-likelihood of the model fit}
}
}
\description{
\code{fitCLS} is used to fit conditional least squares regression
to time series data.
}
\details{
This function regresses the response variable (y) at time t, conditional on the
response at time t-\code{lag.y } and the specified dependent variables (X) at
time t-\code{lag.x}:

\deqn{y(t) = y(t - lag.y) + X(t - lag.x) + \varepsilon}{y(t) = y(t - lag.y) + X(t - lag.x) + e}

where \eqn{y(t)} is the response at time \eqn{t};

\eqn{X(t)} is a model matrix containing covariates;

\eqn{\beta}{beta} is a vector of effects of \eqn{X(t)};

and \eqn{\varepsilon(t)}{t(t)} is a temporally independent Gaussian random
variable with mean zero and standard deviation \eqn{\sigma}{sigma}

\code{stats::lm()} is then called, using the above equation.
}
\examples{

# simulate dummy data
t = 1:30 # times series
Z = rnorm(30) # random independent variable
x = .2*Z + (.05*t) # generate dependent effects
x[2:30] = x[2:30] + .2*x[1:29] # add autocorrelation
x = x + rnorm(30, 0, .01)
df = data.frame(x, t, Z) # collect in data frame

# fit a CLS model with previous x, t, and Z as predictors
## note, this model does not follow the underlying process.
### See below for a better fit.
(CLS <- fitCLS(x ~ t + Z, data = df))

# extract other values
CLS$MSE #MSE
CLS$logLik #log-likelihood

# fit with no lag in independent variables (as simulated):
(CLS2 <- fitCLS(x ~ t + Z, df, lag.x = 0))
summary(CLS2)

# no lag in x
fitCLS(x ~ t + Z, df, lag.y = 0)

# visualize the lag
## large lag in x
fitCLS(x ~ t + Z, df, lag.y = 2, lag.x = 0, debug = TRUE)$lag
## large lag in Z
fitCLS(x ~ t + Z, df, lag.y = 0, lag.x = 2, debug = TRUE)$lag

# # throws errors (NOT RUN)
# fitCLS(x ~ t + Z, df, lag.y = 28) # longer lag than time
# fitCLS(cbind(x, rnorm(30)) ~ t + Z, df) # matrix response

## Methods
summary(CLS)
residuals(CLS)

}
\seealso{
\code{\link{fitCLS_map}} to easily apply \code{fitCLS} to many pixels;
\code{\link{fitAR}} and \code{\link{fitAR_map}} for AR time series analyses.

Other remoteTS: 
\code{\link{fitAR_map}()},
\code{\link{fitAR}()},
\code{\link{fitCLS_map}()}
}
\concept{remoteTS}
